#define USEFOG

float4x4 viewProjMatrix : register (c0);
float4x4 worldMatrix : register (c4);
float4 worldEye: register (c8);
float4 fogData : register (c9);
float4 dirLight : register (c14);

#if OMNI == 1

float4 omniPosRad[12]   : register (c72);
float4 omniRGBDelta[12] : register (c84);

#elif SPOT == 1

float4 spotPosRad[4]    : register (c72);
float4 spotRGBDelta[4]  : register (c80);
float4 spotDirCone[4]   : register (c88);

#endif

struct VS_OUTPUT
{
   float4 Pos  : POSITION;
   float4 Diff : COLOR0;
   float3 Norm : COLOR1;
#ifdef USEFOG
   float  Fog  : FOG;
#endif   
   float2 Tex  : TEXCOORD0;
   float3 Cube : TEXCOORD1;
   float2 Spec : TEXCOORD2;
   float3 Half : TEXCOORD3;
};

#if OMNI == 1

 #if NUMTEX == 1
  VS_OUTPUT vs11_blinnCmapSpecMapOmniT0 (float4 inPos : POSITION, float4 inNorm : NORMAL, float4 inColor : COLOR0, float2 inTex : TEXCOORD0, float2 inSpec : TEXCOORD2)
 #endif
  
#elif SPOT == 1

 #if NUMTEX == 1
  VS_OUTPUT vs11_blinnCmapSpecMapSpotT0 (float4 inPos : POSITION, float4 inNorm : NORMAL, float4 inColor : COLOR0, float2 inTex : TEXCOORD0, float2 inSpec : TEXCOORD2)
 #endif
  
#else

 #if NUMTEX == 1
  VS_OUTPUT vs11_blinnCmapSpecMapT0 (float4 inPos : POSITION, float4 inNorm : NORMAL, float4 inColor : COLOR0, float2 inTex : TEXCOORD0, float2 inSpec : TEXCOORD2)
 #endif
  
#endif
{
  VS_OUTPUT Out;
  
  // Transform vertex position into view space:
  Out.Pos = mul (viewProjMatrix, inPos);

  // Transform vertex normal into world space:
  float3 worldNorm = mul (worldMatrix, inNorm.xyz);
  Out.Norm = ((worldNorm.xyz) * 0.5) + 0.5;

  // compute reflection: E - 2(E dot N)N
  float3 worldPos = mul (worldMatrix, inPos);
  float3 eyeVec = worldEye + worldPos;
  float  EdotN = 2.0 * dot (worldNorm.xyz, eyeVec);
  Out.Cube = eyeVec - (EdotN * worldNorm);
  Out.Half = normalize (dirLight.xyz - normalize (eyeVec).xyz);
  
#ifdef USEFOG
  // compute fog
  Out.Fog.x = (fogData[1] - (length (eyeVec.xyz) * fogData[0]));
#endif   
  
#if OMNI == 1
  // Compute omnilights
  float4 omniColor = (0,0,0,0);
  omniColor.a = inColor.a;
  
  for (int i=0; i<6; i++)
  {
    float intens;
    float3 omniToVert = omniPosRad[i].xyz - worldPos.xyz;
    float mag = dot (omniToVert.xyz, omniToVert.xyz);
    // check if vert in range
    if ( mag < omniPosRad[i].w) // using square distances
      if ((intens = dot (worldNorm, normalize (omniToVert))) > 0) // check backface
        omniColor.rgb += (sqrt(intens) * omniRGBDelta[i].rgb * (1.0F - (sqrt(mag) * omniRGBDelta[i].w)));
  }
  Out.Diff.a = (omniColor.r * 0.30) + (omniColor.g * 0.59) + (omniColor.b * 0.11);
  
#elif SPOT == 1

  // Compute spotlights
  float4 spotColor = (0,0,0,1);
  //for (int i=0; i<numActive.y; i++)
  for (int i=0; i<4; i++)
  {
    // check backface
    if (dot (worldNorm, spotDirCone[i].xyz) <= 0)
    {
      float3 spotToVert = worldPos.xyz - spotPosRad[i].xyz;
      float mag = dot (spotToVert.xyz, spotToVert.xyz);
      // check if vert in range
      if (mag < spotPosRad[i].w) // using square distances
      {
        // check if vert in cone
        mag = dot (normalize (spotToVert.xyz), spotDirCone[i].xyz);
        if (mag > spotDirCone[i].w)
        {
          float intensity = (1.0F - ( sqrt (mag) * spotRGBDelta[i].w));
          spotColor.rgb += (spotRGBDelta[i].rgb * intensity);
        }  
      }
    }
  }
  Out.Diff.a = (spotColor.r * 0.30) + (spotColor.g * 0.59) + (spotColor.b * 0.11);

#else

  Out.Diff.a = 0;

#endif

  // Propagate color and texture coordinates:
  Out.Diff.rgb = inColor;
  Out.Tex = inTex;
  Out.Spec = inSpec;

  return (Out);
}


